using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CSharpSample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            button3.Enabled = false;
            button4.Enabled = false;
            button5.Enabled = false;
            button6.Enabled = false;
            button7.Enabled = false;
            button8.Enabled = false;
            button9.Enabled = false;
            button10.Enabled = false;
            button11.Enabled = false;
            BtnNextPrintPos.Enabled = false;

            LblTrack1.Text = "Click to MSRStart Button";
            LblTrack2.Text = "";
            LblTrack3.Text = "";
        }      

        private void buttonOpenport_Click(object sender, EventArgs e)
        {
         
            string strPort = textBox1.Text;
            if (BxlPrint.PrinterOpen(strPort, 1000) != BxlPrint.BXL_SUCCESS)
            {
                MessageBox.Show("Open Failed!");
                return;
            }

            button3.Enabled = true;
            button4.Enabled = true;
            button5.Enabled = true;
            button6.Enabled = true;
            button7.Enabled = true;
            button8.Enabled = true;
            button9.Enabled = true;
            button10.Enabled =true;
            button11.Enabled =true;
            BtnNextPrintPos.Enabled = true;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            BxlPrint.PrinterClose();
            button3.Enabled = false;
            button4.Enabled = false;
            button5.Enabled = false;
            button6.Enabled = false;
            button7.Enabled = false;
            button8.Enabled = false;
            button9.Enabled = false;
            button10.Enabled = false;
            button11.Enabled = false;
            BtnNextPrintPos.Enabled = false;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            BxlPrint.LineFeed(10);    
        }

        private void button4_Click(object sender, EventArgs e)
        {
             string strDirBmp;
             strDirBmp = "\\Flash Disk\\Test\\logo.bmp"; //Change your bmp location
             if (BxlPrint.PrintBitmap(strDirBmp, 300, BxlPrint.BXL_ALIGNMENT_CENTER, 50) != BxlPrint.BXL_SUCCESS)
                MessageBox.Show("Error PrintBitmap");
            
        }

        private void button5_Click(object sender, EventArgs e)
        {
            //Sample UPCA Barcode print

            byte[] bytes = new byte[12] { 0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x31,0x32};            
                        
            BxlPrint.PrintBarcode(bytes, BxlPrint.BXL_BCS_UPCA, 50, 2, BxlPrint.BXL_ALIGNMENT_LEFT, BxlPrint.BXL_BC_TEXT_ABOVE);
        }

        private void button6_Click(object sender, EventArgs e)
        {
        	string t = "Receipt";
            BxlPrint.PrintText(t, BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD | BxlPrint.BXL_FT_UNDERLINE, BxlPrint.BXL_TS_1WIDTH | BxlPrint.BXL_TS_1HEIGHT);	
            BxlPrint.PrintText(" \n\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD | BxlPrint.BXL_FT_UNDERLINE, BxlPrint.BXL_TS_1WIDTH | BxlPrint.BXL_TS_1HEIGHT);

            BxlPrint.PrintText("------------------------------\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_DEFAULT, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText(" Apple      3             $3.0\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_DEFAULT, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText(" Cola       1             $1.2\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_DEFAULT, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText(" Milk       2             $1.8\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_DEFAULT, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText(" Juice      1             $2.0\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_DEFAULT, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText("------------------------------\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_DEFAULT, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText(" Total                    $8.0\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText(" Cash                     $8.0\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText("                          $0.0\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);	

            //////////////////////////////////////////////////////////////////////////
            //Set multi attribute in one line.
            BxlPrint.PrintText("Test", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText("BBB", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_FONTB | BxlPrint.BXL_FT_BOLD, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText("CCC", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_FONTB | BxlPrint.BXL_FT_REVERSE, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText("DDD", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD | BxlPrint.BXL_FT_UNDERLINE, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);
            BxlPrint.PrintText("\n", BxlPrint.BXL_ALIGNMENT_CENTER, BxlPrint.BXL_FT_BOLD | BxlPrint.BXL_FT_UNDERLINE, BxlPrint.BXL_TS_0WIDTH | BxlPrint.BXL_TS_0HEIGHT);            
            

            Int32 lResult = BxlPrint.LineFeed(5);
            if(lResult != BxlPrint.BXL_SUCCESS)
            {
	            MessageBox.Show("Error LineFeeding");
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            bool bNormal = true;
            
            if( BxlPrint.CheckPrinter() != BxlPrint.BXL_SUCCESS)
            {
                MessageBox.Show("Printer is Error");
                bNormal = false;
            }else{
                Int32 lResult;
                lResult = BxlPrint.GetStat();// 'lResult Value is BXL_STS.... 
                if(lResult != BxlPrint.BXL_STS_NORMAL)
                {
                    string strStatus;
                    strStatus = "Printer Status is Error : " + lResult.ToString();
                    MessageBox.Show(strStatus);
                    bNormal = false;
                }                

                lResult = BxlPrint.GetPowerValue();
                if(lResult > 2)
                {
                    MessageBox.Show("Printer power is low!");
                    bNormal = false;
                }               
            }            
            
            if(bNormal == true)
                MessageBox.Show("Printer status is Normal");
            
        }

        private void button8_Click(object sender, EventArgs e)
        {
            Int32 nCharSet;
            BxlPrint.SetCharacterSet(BxlPrint.BXL_CS_PC850);

            nCharSet = BxlPrint.GetCharacterSet();
            if(nCharSet != BxlPrint.BXL_CS_PC850 )
                MessageBox.Show("Failed to set SetCharacterSet");
            else
                MessageBox.Show("Success to set SetCharacterSet");
        
            BxlPrint.SetInterChrSet(BxlPrint.BXL_ICS_FRANCE);

            nCharSet = BxlPrint.GetInterChrSet();
            if(nCharSet != BxlPrint.BXL_ICS_FRANCE)
                MessageBox.Show("Failed to set International CharacterSet");
            else
                MessageBox.Show("Success to set International CharacterSet");
        
        }

        private void button9_Click(object sender, EventArgs e)
        {
            //DirectIO Test
            byte[] bytes = new byte[3] {16,4,1};
            byte[] ReadBuf = new byte[2] {0,0};
            UInt32 nbyte;
            UInt32 nRead;
            Int32 lResult ;

            nRead = 1;
            nbyte = 3;
            
            lResult = BxlPrint.DirectIO(bytes, nbyte, ReadBuf,ref nRead);

            if(lResult == BxlPrint.BXL_SUCCESS)
            {
                if(ReadBuf[0] == 18)
                    MessageBox.Show("Success");
            }        
        
        }

        private void button10_Click(object sender, EventArgs e)
        {
            BxlPrint.MsrReadReady();

            if(BxlPrint.GetStat() != BxlPrint.BXL_STS_MSR_READY)
              return;
            
            LblTrack1.Text = "Ready MSR Mode...";
            LblTrack2.Text = "";
            LblTrack3.Text = "";

            
            timer1.Enabled = true;
        }

        private void button11_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            BxlPrint.MsrReadCancel();
            LblTrack1.Text = "Please 'MSRStart' Button";
            LblTrack2.Text = "";
            LblTrack3.Text = "";
        }

        public const Int32 BXL_TRACK = 200;
        private void timer1_Tick(object sender, EventArgs e)
        {
            if(radioButton1.Checked)
                read_track_function();
            else        
                read_track_function2();                
        }
        //use MsrReadTrack Funtion

        private void read_track_function()
        {
            byte[] cTrack1 = new byte[BXL_TRACK];
            byte[] cTrack2 = new byte[BXL_TRACK];
            byte[] cTrack3 = new byte[BXL_TRACK];

            Int32 lResult;
            ASCIIEncoding ascii = new ASCIIEncoding();


            lResult = BxlPrint.MsrReadTrack(cTrack1, cTrack2, cTrack3);
            if (lResult == BxlPrint.BXLMSR_DATAEMPTY)
                return;                       
            
            LblTrack1.Text = ascii.GetString(cTrack1, 0, BXL_TRACK);
            LblTrack2.Text = ascii.GetString(cTrack2, 0, BXL_TRACK);
            LblTrack3.Text = ascii.GetString(cTrack3, 0, BXL_TRACK);

            timer1.Enabled = false;
        }

        

        //use MsrReadFullTrack Funtion
        private void read_track_function2()
        {

            byte[] cTrack = new byte[600];
            Int32 lResult;  


            lResult = BxlPrint.MsrReadFullTrack(cTrack, 600);
            if (lResult != BxlPrint.BXL_SUCCESS)
                return;

            ASCIIEncoding ascii = new ASCIIEncoding();
            LblTrack1.Text = "Use MSRReadFullTrack Functions";
            LblTrack2.Text = ascii.GetString(cTrack, 0, 600);           
            LblTrack3.Text = "";

            timer1.Enabled = false;
        }

        

        private void BtnNextPrintPos_Click(object sender, EventArgs e)
        {
            BxlPrint.NextPrintPos();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {

        }
        
    }
}