Imports System
Imports System.Runtime.InteropServices
Imports Microsoft.VisualBasic

Module BxlPrint

    '  // This file supports all Platforms, but this sample code only supports PDA Platforms
    '// so if you want to use this sample code in PC platform, you should create a new project for 
    '// PC Platform and add file in your project.

    Public Const BXLDIR As String = "bxl.dll"


    'Method return value
    Public Const BXL_SUCCESS As Integer = 0
    Public Const BXL_READBUFFER_EMPTY As Integer = 1

    Public Const BXL_OTHERPTR_OPENED As Integer = 100
    Public Const BXL_NOT_OPENED As Integer = 101
    Public Const BXL_CREATE_ERROR As Integer = 102
    Public Const BXL_STATUS_ERROR As Integer = 103
    Public Const BXL_WATING_OPEN As Integer = 104
    Public Const BXL_CONNECT_ERROR As Integer = 105
    Public Const BXL_BDADDR_ERROR As Integer = 106
    Public Const BXL_NOT_SUPPORT As Integer = 107        
    Public Const BXL_BAD_ARGUMENT As Integer = 108
		Public Const BXL_BUFFER_ERROR	As Integer =109

    Public Const BXL_REGISTRY_ERROR As Integer = 200
    Public Const BXL_WRITE_ERROR As Integer = 300
    Public Const BXL_READ_ERROR As Integer = 301

    Public Const BXL_BITMAPLOAD_ERROR As Integer = 400
    Public Const BXL_BITMAPDATA_ERROR As Integer = 401

    Public Const BXL_BC_DATA_ERROR As Integer = 500
    Public Const BXL_BC_NOT_SUPPORT As Integer = 501

    'MSR State Return
    Public Const BXLMSR_FAILEDMODE As Integer = 601
    Public Const BXLMSR_NOTREADY As Integer = 602
    Public Const BXLMSR_DATAEMPTY As Integer = 603

    'Printer Status flag
    Public Const BXL_STS_NORMAL As Integer = 0
    Public Const BXL_STS_PAPEREMPTY As Integer = 1
    Public Const BXL_STS_COVEROPEN As Integer = 2
    Public Const BXL_STS_POWEROVER As Integer = 4
    Public Const BXL_STS_MSR_READY As Integer = 8
    Public Const BXL_STS_PRINTING As Integer = 16
    Public Const BXL_STS_ERROR As Integer = 32
    Public Const BXL_STS_NOT_OPEN As Integer = 64
    Public Const BXL_STS_ERROR_OCCUR As Integer = 128

    'Power Status
    Public Const BXL_PWR_HIGH As Integer = 0
    Public Const BXL_PWR_MIDDLE As Integer = 1
    Public Const BXL_PWR_LOW As Integer = 2
    Public Const BXL_PWR_SMALL As Integer = 3
    Public Const BXL_PWR_NOT As Integer = 4

    'Alignment Code
    Public Const BXL_ALIGNMENT_LEFT As Integer = 0
    Public Const BXL_ALIGNMENT_CENTER As Integer = 1
    Public Const BXL_ALIGNMENT_RIGHT As Integer = 2

    '//Text Attribute
    Public Const BXL_FT_DEFAULT As Integer = 0
    Public Const BXL_FT_FONTB As Integer = 1
    Public Const BXL_FT_FONTC As Integer = 16
    Public Const BXL_FT_BOLD As Integer = 2
    Public Const BXL_FT_UNDERLINE As Integer = 4
    Public Const BXL_FT_REVERSE As Integer = 8
    Public Const BXL_ExFT_CHINA_FONTA As Integer = 0
    Public Const BXL_ExFT_CHINA_FONTB As Integer = 32

    'Text Size Attribute
    Public Const BXL_TS_0WIDTH As Integer = 0
    Public Const BXL_TS_1WIDTH As Integer = 16
    Public Const BXL_TS_2WIDTH As Integer = 32
    Public Const BXL_TS_3WIDTH As Integer = 48
    Public Const BXL_TS_4WIDTH As Integer = 64
    Public Const BXL_TS_5WIDTH As Integer = 80
    Public Const BXL_TS_6WIDTH As Integer = 96
    Public Const BXL_TS_7WIDTH As Integer = 112

    Public Const BXL_TS_0HEIGHT As Integer = 0
    Public Const BXL_TS_1HEIGHT As Integer = 1
    Public Const BXL_TS_2HEIGHT As Integer = 2
    Public Const BXL_TS_3HEIGHT As Integer = 3
    Public Const BXL_TS_4HEIGHT As Integer = 4
    Public Const BXL_TS_5HEIGHT As Integer = 5
    Public Const BXL_TS_6HEIGHT As Integer = 6
    Public Const BXL_TS_7HEIGHT As Integer = 7

    'Width Full
    Public Const BXL_WIDTH_FULL As Integer = -1
    Public Const BXL_WIDTH_NONE As Integer = -2

    'Barcode    
    Public Const BXL_BCS_PDF417				  As Integer =200
		Public Const BXL_BCS_QRCODE_MODEL2	As Integer =202 
		Public Const BXL_BCS_QRCODE_MODEL1	As Integer =203 
		Public Const BXL_BCS_DATAMATRIX			As Integer =204
		Public Const BXL_BCS_MAXICODE_MODE2	As Integer =205 
		Public Const BXL_BCS_MAXICODE_MODE3	As Integer =206 
		Public Const BXL_BCS_MAXICODE_MODE4	As Integer =207 

    Public Const BXL_BCS_UPCA As Integer = 101
    Public Const BXL_BCS_UPCE As Integer = 102
    Public Const BXL_BCS_EAN8 As Integer = 103
    Public Const BXL_BCS_EAN13 As Integer = 104
    Public Const BXL_BCS_JAN8 As Integer = 105
    Public Const BXL_BCS_JAN13 As Integer = 106
    Public Const BXL_BCS_ITF As Integer = 107
    Public Const BXL_BCS_Codabar As Integer = 108
    Public Const BXL_BCS_Code39 As Integer = 109
    Public Const BXL_BCS_Code93 As Integer = 110
    Public Const BXL_BCS_Code128 As Integer = 111

    'Barcode text position
    Public Const BXL_BC_TEXT_NONE As Integer = 0
    Public Const BXL_BC_TEXT_ABOVE As Integer = 1
    Public Const BXL_BC_TEXT_BELOW As Integer = 2

   'CharaterSet
    Public Const BXL_CS_PC437 As Integer = 0
    Public Const BXL_CS_PC850 As Integer = 2
    Public Const BXL_CS_PC860 As Integer = 3
    Public Const BXL_CS_PC863 As Integer = 4
    Public Const BXL_CS_PC865 As Integer = 5
    Public Const BXL_CS_WPC1252 As Integer = 16
    Public Const BXL_CS_PC866 As Integer = 17
    Public Const BXL_CS_PC852 As Integer = 18
    Public Const BXL_CS_PC858 As Integer = 19
    Public Const BXL_CS_PC864 As Integer = 22
    Public Const BXL_CS_THAI42 As Integer = 23
    Public Const BXL_CS_WPC1253 As Integer = 24    
    Public Const BXL_CS_WPC1254 As Integer = 25
    Public Const BXL_CS_WPC1257 As Integer = 26
    Public Const BXL_CS_FARSI As Integer = 27    
    Public Const BXL_CS_WPC1251 As Integer = 28
    Public Const BXL_CS_PC737 As Integer = 29
    Public Const BXL_CS_PC775 As Integer = 30
    Public Const BXL_CS_THAI14 As Integer = 31
    Public Const BXL_CS_PC862 As Integer = 33
    Public Const BXL_CS_PC855 As Integer = 36
    Public Const BXL_CS_PC857 As Integer = 37
    Public Const BXL_CS_PC928 As Integer = 38
    Public Const BXL_CS_THAI16 As Integer = 39
    Public Const BXL_CS_WPC1256 As Integer = 40
    Public Const BXL_CS_USER As Integer = 255

    'International CharacterSet
    Public Const BXL_ICS_USA As Integer = 0
    Public Const BXL_ICS_FRANCE As Integer = 1
    Public Const BXL_ICS_GERMANY As Integer = 2
    Public Const BXL_ICS_UK As Integer = 3
    Public Const BXL_ICS_DENMARK1 As Integer = 4
    Public Const BXL_ICS_SWEDEN As Integer = 5
    Public Const BXL_ICS_ITALY As Integer = 6
    Public Const BXL_ICS_SPAIN As Integer = 7
    Public Const BXL_ICS_NORWAY As Integer = 9
    Public Const BXL_ICS_DENMARK2 As Integer = 10

    'MSR Mode 
    Public Const BXL_MSRMODE_CMDTRACK12 As Integer = 0
    Public Const BXL_MSRMODE_CMDTRACK23 As Integer = 1
    Public Const BXL_MSRMODE_AUTOTRACK1 As Integer = 2
    Public Const BXL_MSRMODE_AUTOTRACK2_1 As Integer = 3
    Public Const BXL_MSRMODE_AUTOTRACK12 As Integer = 4
    Public Const BXL_MSRMODE_AUTOTRACK2_2 As Integer = 5
    Public Const BXL_MSRMODE_AUTOTRACK3 As Integer = 6
    Public Const BXL_MSRMODE_AUTOTRACK23 As Integer = 7
    
    
    Public Const WM_MSR_ARRIVED As Integer = 1027
    Public Const BXL_LPARAM_MSR As Integer = 10

		'wParam argument 
    Public Const BXL_MSG_TRACK1 As Integer = 1
    Public Const BXL_MSG_TRACK2 As Integer = 2
    Public Const BXL_MSG_TRACK3 As Integer = 4
    Public Const BXL_MSG_TRACK_ENCRIPTION As Integer = 8

    <DllImport("coredll")> _
      Public Function LoadLibrary(ByVal LibName As String) As Int32
    End Function
    <DllImport("coredll")> _
    Public Function FreeLibrary(ByVal hLib As Int32) As Int32
    End Function

    <DllImport(BXLDIR, EntryPoint:="PrinterOpen")> _
    Public Function PrinterOpen(ByVal strOutPortName As String, ByVal lTimeout As Int32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="PrinterClose")> _
     Public Function PrinterClose() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="LineFeed")> _
    Public Function LineFeed(ByVal nFeed As Int32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="PrintBitmap")> _
    Public Function PrintBitmap(ByVal FileName As String, ByVal Width As Int32, ByVal Alignment As Int32, ByVal Level As Int32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="PrintBarcode")> _
    Public Function PrintBarcode(ByVal Data As Byte(), ByVal Symbology As Int32, ByVal Height As Int32, ByVal Width As Int32, ByVal Alignment As Int32, ByVal TextPosition As Int32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="PrintText")> _
    Public Function PrintText(ByVal Data As String, ByVal Alignment As Int32, ByVal Attribute As Int32, ByVal TextSize As Int32) As Int32
    End Function    
    <DllImport(BXLDIR, EntryPoint:="SetCharacterSet")> _
    Public Function SetCharacterSet(ByVal Value As Int32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="SetInterChrSet")> _
    Public Function SetInterChrSet(ByVal Value As Int32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="GetCharacterSet")> _
    Public Function GetCharacterSet() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="GetInterChrSet")> _
    Public Function GetInterChrSet() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="DirectIO")> _
    Public Function DirectIO(ByVal Data As Byte(), ByVal iWrite As UInt32, ByVal pRequest As Byte(), ByRef iRead As UInt32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="MsrReadReady")> _
    Public Function MsrReadReady() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="MsrReadCancel")> _
    Public Function MsrReadCancel() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="MsrReadTrack")> _
    Public Function MsrReadTrack(ByVal Data1 As Byte(), ByVal Data2 As Byte(), ByVal Data3 As Byte()) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="CheckPrinter")> _
    Public Function CheckPrinter() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="GetPowerValue")> _
    Public Function GetPowerValue() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="GetStat")> _
    Public Function GetStat() As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="GetResultCode")> _
    Public Function GetResultCode() As Int32
    End Function 
    <DllImport(BXLDIR, EntryPoint:="NextPrintPos")> _
    Public Function NextPrintPos() As Int32
    End Function
    'file ver 1.0.0.13 main ver 1.0.6 add function (for MSR) 
    <DllImport(BXLDIR, EntryPoint:="GetTrack1")> _
    Public Function GetTrack1() As String
    End Function
    <DllImport(BXLDIR, EntryPoint:="GetTrack2")> _
    Public Function GetTrack2() As String
    End Function
    <DllImport(BXLDIR, EntryPoint:="GetTrack3")> _
    Public Function GetTrack3() As String
    End Function
    <DllImport(BXLDIR, EntryPoint:="MsrReadFullTrack")> _
    Public Function MsrReadFullTrack(ByVal Data As Byte(), ByVal iLen As UInt32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="MsrRead1Track")> _
    Public Function MsrRead1Track(ByVal Data As Byte(), ByVal iLen As UInt32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="MsrRead2Track")> _
    Public Function MsrRead2Track(ByVal Data As Byte(), ByVal iLen As UInt32) As Int32
    End Function
    <DllImport(BXLDIR, EntryPoint:="MsrRead3Track")> _
    Public Function MsrRead3Track(ByVal Data As Byte(), ByVal iLen As UInt32) As Int32
    End Function


    Public Function IsValidLib(ByVal LibName As String) As Boolean
        Dim hLib As Int32 = LoadLibrary(LibName)
        If hLib <> 0 Then
            FreeLibrary(hLib)
            IsValidLib = True
        Else
            IsValidLib = False
        End If
    End Function

    Public Function StringToAscii(ByRef Cmd() As Byte, ByVal pos As Integer, ByVal data As String) As Integer
        Dim i As Integer
        For i = 1 To Len(data)
            Cmd(pos) = Asc(Mid(data, i, 1))
            pos = pos + 1
        Next i
        StringToAscii = pos
    End Function
End Module
