Imports System
Imports System.Runtime.InteropServices
Imports Microsoft.VisualBasic
Imports System.Text

Public Class Form1
    'Inherits System.Windows.Forms.Form
    'Define BXL SDK Header     
    
    Private Sub BtnOpenPort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnOpenPort.Click
        Dim lresult As Long
        lresult = 0
        lresult = PrinterOpen(txtPort.Text, 1000)
        If lresult = 0 Then
            BtnSampleprint.Enabled = True
            BtnBmpPrint.Enabled = True
            BtnBarcode.Enabled = True
            Button1.Enabled = True
            BtnStatus.Enabled = True
            BtnProperty.Enabled = True
            Button4.Enabled = True
            BtnMSRStart.Enabled = True
            BtnMSRcancel.Enabled = True
            Button2.Enabled = True
            Button3.Enabled = True
            Button5.Enabled = True
        Else
            Dim strRe As String
            strRe = "Open Error code = " + lresult.ToString
            MessageBox.Show("Open Error!")
        End If

    End Sub

    Private Sub BtnClosePort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnClosePort.Click
        PrinterClose()
    End Sub

    Private Sub BtnSampleprint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnSampleprint.Click
        Dim lresult As Long
        lresult = 0
        lresult = LineFeed(10)
    End Sub

    Public Sub New()

        
        InitializeComponent()

        If IsValidLib(BXLDIR) = False Then
            MessageBox.Show("Unknown architecture!")
            Close()
        End If

        BtnSampleprint.Enabled = False
        BtnBmpPrint.Enabled = False
        BtnBarcode.Enabled = False
        Button1.Enabled = False
        BtnStatus.Enabled = False
        BtnProperty.Enabled = False
        Button4.Enabled = False
        BtnMSRStart.Enabled = False
        BtnMSRcancel.Enabled = False
        Button2.Enabled = False
        Button3.Enabled = False
        Button5.Enabled = False

    End Sub
    

    Private Sub BtnBmpPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnBmpPrint.Click
        Dim strDirBmp As String
        strDirBmp = "\SD Card\logo.bmp" 'Change your bmp location
        If PrintBitmap(strDirBmp, 300, BXL_ALIGNMENT_CENTER, 50) <> BXL_SUCCESS Then
            MessageBox.Show("Error PrintBitmap")
        End If


    End Sub

    Private Sub BtnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnExit.Click
        Close()
    End Sub

    Private Sub BtnBarcode_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnBarcode.Click

        'Sample UPCA Barcode print

        Dim bytes() As Byte
        Dim chars As String = "123456789012"

        Dim ascii As New ASCIIEncoding()

        Dim byteCount As Integer = ascii.GetByteCount(chars.ToCharArray(), 0, 12)
        bytes = New Byte(byteCount - 1) {}
        Dim bytesEncodedCount As Integer = ascii.GetBytes(chars, 0, 12, bytes, 0)
        
        PrintBarcode(bytes, BXL_BCS_UPCA, 50, 2, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_ABOVE)

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim t As String
        t = "Receipt"
        PrintText(t, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD + BXL_FT_UNDERLINE, BXL_TS_1WIDTH + BXL_TS_1HEIGHT)
        PrintText(vbLf + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD + BXL_FT_UNDERLINE, BXL_TS_1WIDTH + BXL_TS_1HEIGHT)

        PrintText("------------------------------" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText(" Apple      3             $3.0" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText(" Cola       1             $1.2" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText(" Milk       2             $1.8" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText(" Juice      1             $2.0" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText("------------------------------" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText(" Total                    $8.0" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText(" Cash                     $8.0" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText("                          $0.0" + vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)

        'Set multi attribute in one line.
        PrintText("Test", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText("BBB", BXL_ALIGNMENT_CENTER, BXL_FT_FONTB + BXL_FT_BOLD, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText("CCC", BXL_ALIGNMENT_CENTER, BXL_FT_FONTB + BXL_FT_REVERSE, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText("DDD", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD + BXL_FT_UNDERLINE, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)
        PrintText(vbLf, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD + BXL_FT_UNDERLINE, BXL_TS_0WIDTH + BXL_TS_0HEIGHT)

        LineFeed(5)

    End Sub

    Private Sub BtnStatus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnStatus.Click
        Dim bNormal As Boolean
        bNormal = True
        If CheckPrinter() <> BXL_SUCCESS Then
            MessageBox.Show("Printer is Error")
            bNormal = False
        Else
            Dim lResult As Integer
            lResult = GetStat() 'lResult Value is BXL_STS.... 
            If lResult <> BXL_STS_NORMAL Then
                Dim strStatus As String
                strStatus = "Printer Status is Error : " + lResult.ToString()
                MessageBox.Show(strStatus)
                bNormal = False
            End If

            lResult = GetPowerValue()
            If lResult > 2 Then
                MessageBox.Show("Printer power is low!")
                bNormal = False
            End If
        End If

        If bNormal = True Then
            MessageBox.Show("Printer status is Normal")
        End If
    End Sub

    Private Sub BtnProperty_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnProperty.Click
        Dim nCharSet As Integer
        SetCharacterSet(BXL_CS_PC850)

        nCharSet = GetCharacterSet()
        If nCharSet <> BXL_CS_PC850 Then
            MessageBox.Show("Failed to set SetCharacterSet")
        Else
            MessageBox.Show("Success to set SetCharacterSet")
        End If

        SetInterChrSet(BXL_ICS_FRANCE)

        nCharSet = GetInterChrSet()
        If nCharSet <> BXL_ICS_FRANCE Then
            MessageBox.Show("Failed to set International CharacterSet")
        Else
            MessageBox.Show("Success to set International CharacterSet")
        End If
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        'DirectIO Test
        Dim bytes() As Byte
        Dim ReadBuf() As Byte
        Dim nbyte As UInt32
        Dim nRead As UInt32
        Dim lResult As Integer

        nRead = 1
        nbyte = 3
        bytes = New Byte(2) {16, 4, 1}
        ReadBuf = New Byte(2) {0, 0, 0}
        lResult = DirectIO(bytes, nbyte, ReadBuf, nRead)

        If lResult = BXL_SUCCESS Then
            If ReadBuf(0) = 18 Then
                MessageBox.Show("Success")
            End If
        End If
    End Sub

    Private Sub BtnMSRStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnMSRStart.Click
        MsrReadReady()

        If GetStat() <> BXL_STS_MSR_READY Then
            Exit Sub
        End If

        LblTrack1.Text = "Ready MSR Mode..."
        LblTrack2.Text = ""
        LblTrack3.Text = ""

        If CheckBox1.Checked Then
            Timer1.Enabled = True
        End If

    End Sub

    Private Sub BtnMSRcancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnMSRcancel.Click
        Timer1.Enabled = False
        MsrReadCancel()
        LblTrack1.Text = "Please 'MSRStart' Button"
        LblTrack2.Text = ""
        LblTrack3.Text = ""

    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Dim cTrack1() As Byte
        Dim cTrack2() As Byte
        Dim cTrack3() As Byte
        Dim lResult As Integer

        cTrack1 = New Byte(200) {}
        cTrack2 = New Byte(200) {}
        cTrack3 = New Byte(200) {}


        lResult = MsrReadTrack(cTrack1, cTrack2, cTrack3)
        
        If lResult = BXLMSR_DATAEMPTY Then
            Exit Sub
        End If

        
        Dim ascii As New ASCIIEncoding()
        LblTrack1.Text = ascii.GetString(cTrack1, 0, 200)
        LblTrack2.Text = ascii.GetString(cTrack2, 0, 200)
        LblTrack3.Text = ascii.GetString(cTrack3, 0, 200)

        Timer1.Enabled = False
    End Sub

   
    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        NextPrintPos()
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        'Use MsrReadFullTrack
        Dim cTrack1() As Byte
        Dim cTrack2() As Byte
        Dim cTrack3() As Byte
        Dim lResult As Integer

        cTrack1 = New Byte(200) {}
        cTrack2 = New Byte(200) {}
        cTrack3 = New Byte(200) {}

        lResult = MsrRead1Track(cTrack1, 200)
        lResult = MsrRead2Track(cTrack2, 200)
        lResult = MsrRead3Track(cTrack3, 200)

        Dim ascii As New ASCIIEncoding()
        LblTrack1.Text = ascii.GetString(cTrack1, 0, 200)
        LblTrack2.Text = ascii.GetString(cTrack2, 0, 200)
        LblTrack3.Text = ascii.GetString(cTrack3, 0, 200)

    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click

        'Use MsrRead1,2,3Track
        'Use MsrReadFullTrack
        Dim cFullTrack() As Byte
        Dim lResult As Integer

        cFullTrack = New Byte(600) {}

        lResult = MsrReadFullTrack(cFullTrack, 600)

        If lResult <> BXL_SUCCESS Then
            LblTrack1.Text = "Use MsrReadFullTrack : EMPTY DATA"
            Exit Sub
        End If

        Dim ascii As New ASCIIEncoding()
        LblTrack1.Text = "Use MsrReadFullTrack"
        LblTrack2.Text = ascii.GetString(cFullTrack, 0, 600)


    End Sub
End Class



