// MSRDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample.h"
#include "MSRDlg.h"

//#include "../inc/ExportFunc.h"
#include "../inc/DynamicFunc.h"
#include "../inc/BxlConst.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMSRDlg dialog


CMSRDlg::CMSRDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMSRDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMSRDlg)
	m_strTrack1 = _T("");
	m_strTrack2 = _T("");
	m_strTrack3 = _T("");
	m_bMsrMsgUsed = FALSE;
	//}}AFX_DATA_INIT
}


void CMSRDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMSRDlg)
	DDX_Text(pDX, IDC_EDIT1, m_strTrack1);
	DDX_Text(pDX, IDC_EDIT2, m_strTrack2);
	DDX_Text(pDX, IDC_EDIT3, m_strTrack3);
	DDX_Check(pDX, IDC_CHECK4, m_bMsrMsgUsed);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMSRDlg, CDialog)
	//{{AFX_MSG_MAP(CMSRDlg)
	ON_BN_CLICKED(IDC_BUTTON1, OnMSRREADSTART)
	ON_BN_CLICKED(IDC_BUTTON2, OnCANCELREAD)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CHECK4, OnCheck4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMSRDlg message handlers

void CMSRDlg::OnMSRREADSTART() 
{
	SetMsrMessageValue(5);
	KillTimer(100);
	m_bMode = FALSE;
	MsrReadReady();	
	if(GetStat() != BXL_STS_MSR_READY)
	{
		m_strTrack1.Format(L"Not MSR Ready Mode : %d", GetStat());
		UpdateData(FALSE);
		return;
	}	

	UpdateData(TRUE);
	if(!m_bMsrMsgUsed)
		SetTimer(100,100, NULL);			
}

void CMSRDlg::OnCANCELREAD() 
{
	m_bMode = TRUE;

	UpdateData(TRUE);
	if(!m_bMsrMsgUsed)
		KillTimer(100);

	m_strTrack1 = L"- Cancel to Read Card";				
	UpdateData(FALSE);
	MsrReadCancel();
	
}

void CMSRDlg::OnOK() 
{

	CDialog::OnOK();
}

void CMSRDlg::OnTimer(UINT nIDEvent) 
{
	KillTimer(100);
	CHAR dbTrack1[200];
	CHAR dbTrack2[200];
	CHAR dbTrack3[200];
	BOOL bTrack1 = FALSE;
	BOOL bTrack2 = FALSE;
	BOOL bTrack3 = FALSE;
	memset(dbTrack1, 0, sizeof(dbTrack1));
	memset(dbTrack2, 0, sizeof(dbTrack2));
	memset(dbTrack3, 0, sizeof(dbTrack3 ));	
	
	long lResult = MsrReadTrack(dbTrack1, dbTrack2, dbTrack3);
	if(lResult == BXLMSR_DATAEMPTY)
	{		
		if(!m_bMode){
			m_strTrack1 = L"Wait to Read Card";		
			m_strTrack2 = L"..";				
			UpdateData(FALSE);
			SetTimer(100,100, NULL);	
			
		}else
		{
			m_strTrack1 = L"Cancel to Read Card";				
			UpdateData(FALSE);
		}		
		return;		
	}
	

	CString strData1(dbTrack1,200);
	m_strTrack1 = strData1;
	CString strData2(dbTrack2, 200);
	m_strTrack2 = strData2;
	CString strData3(dbTrack3, 200);
	m_strTrack3 = strData3;		
	UpdateData(FALSE);

	
	CDialog::OnTimer(nIDEvent);
}

BOOL CMSRDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_bMsrMsgUsed = FALSE;
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CMSRDlg::PreTranslateMessage(MSG* pMsg) 
{
	UpdateData(TRUE);
	if(!m_bMsrMsgUsed)
		return CDialog::PreTranslateMessage(pMsg);
		
	if(pMsg->message == WM_USER+5 && pMsg->lParam == BXL_LPARAM_MSR )
	{		
		
		if(pMsg->wParam & BXL_MSG_TRACK1)
			m_strTrack1 = GetTrack1();
		
		if(pMsg->wParam & BXL_MSG_TRACK2)
			m_strTrack2 = GetTrack2();

		if(pMsg->wParam & BXL_MSG_TRACK3)
			m_strTrack3 = GetTrack3();

		UpdateData(FALSE);
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CMSRDlg::OnCheck4() 
{
	if(m_bMsrMsgUsed)
		m_bMsrMsgUsed = FALSE;
	else
	{
		m_bMsrMsgUsed = TRUE;
		SetMsrMsgMode(m_bMsrMsgUsed);
	}
	
}
