// PrintingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample.h"
#include "PrintingDlg.h"

//#include "../inc/ExportFunc.h"
#include "../inc/DynamicFunc.h"
#include "../inc/BxlConst.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrintingDlg dialog


CPrintingDlg::CPrintingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPrintingDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrintingDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CPrintingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrintingDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPrintingDlg, CDialog)
	//{{AFX_MSG_MAP(CPrintingDlg)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrintingDlg message handlers

void CPrintingDlg::OnButton1() 
{
	CString strError;
	long lResult = 0;
	lResult = CheckPrinter();
	//Printer State Check
	if( lResult != BXL_SUCCESS)
	{		
		strError.Format(L"Printer is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = GetStat();
	if( lResult != BXL_STS_NORMAL)
	{
		strError.Format(L"Printer State is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	WCHAR t[10] = L"Receipt";
	PrintText(t, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_1WIDTH | BXL_TS_1HEIGHT);	
	PrintText(L" \n\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_1WIDTH | BXL_TS_1HEIGHT);	
	
	PrintText(L"------------------------------\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH | BXL_TS_0HEIGHT);
	PrintText(L" Apple      3             $3.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);
	PrintText(L" Cola       1             $1.2\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L" Milk       2             $1.8\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L" Juice      1             $2.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"------------------------------\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L" Total                    $8.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L" Cash                     $8.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L" ׽Ʈ ѱ                          $0.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	

	//////////////////////////////////////////////////////////////////////////
	//Set multi attribute in one line.
	PrintText(L"Test", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"BBB", BXL_ALIGNMENT_CENTER, BXL_FT_FONTB | BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"CCC", BXL_ALIGNMENT_CENTER, BXL_FT_FONTB | BXL_FT_REVERSE, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"DDD", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	

	PrintBarcode("12345678", BXL_BCS_ITF, 100, 2, BXL_ALIGNMENT_CENTER, BXL_BC_TEXT_BELOW);


	PrintText(L"Test Select Font\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"ASCII Font A ABCDEFG...\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"ASCII Font B ABCDEFG...\n", BXL_ALIGNMENT_CENTER, BXL_FT_FONTB, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(L"ASCII Font C ABCDEFG...\n", BXL_ALIGNMENT_CENTER, BXL_FT_FONTC, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
//	//TCHAR test[4] = {0x8140,0x8141,0x8142, 0x0a};
//	TCHAR test[4] = {0x4081,0x4181,0x4281, 0x0a};
//	PrintText(L"CHINESE Font B\n", BXL_ALIGNMENT_CENTER, BXL_ExFT_CHINA_FONTB, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
//	PrintText(test, BXL_ALIGNMENT_CENTER, BXL_ExFT_CHINA_FONTB, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
//	LineFeed(1);
//	PrintText(L"CHINESE Font A\n", BXL_ALIGNMENT_CENTER, BXL_ExFT_CHINA_FONTB, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
//	PrintText(test, BXL_ALIGNMENT_CENTER, BXL_ExFT_CHINA_FONTA, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
//	CHAR dbRead = 0;
//	UINT dwRead = 0;
	LineFeed(6);
	
}

void CPrintingDlg::OnButton3() 
{
	CString strError;
	long lResult = 0;
	lResult = CheckPrinter();
	//Printer State Check
	if( lResult != BXL_SUCCESS)
	{		
		strError.Format(L"Printer is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = GetStat();
	if( lResult != BXL_STS_NORMAL)
	{
		strError.Format(L"Printer State is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	CString strFile;
	CFileDialog FileDlg(TRUE, L"", strFile, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, L"Image File(*.bmp)|*.bmp|Image File(*.jpg)|*.jpg|Image File(*.gif)|*.gif||");
	
	if(FileDlg.DoModal() == IDOK)
	{
		strFile = FileDlg.GetPathName();
	}else
		return;

	PrintBitmap(strFile, 300, BXL_ALIGNMENT_CENTER, 50);
	
}

void CPrintingDlg::OnButton4() 
{
	CString strError;
	long lResult = 0;
	lResult = CheckPrinter();
	//Printer State Check
	if( lResult != BXL_SUCCESS)
	{		
		strError.Format(L"Printer is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = GetStat();
	if( lResult != BXL_STS_NORMAL)
	{
		strError.Format(L"Printer State is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}
	int i = 0;
	//UPCA Printing

	for(i = 2; i < 7; i+=2 )
	{	
		PrintText(L"BARCODE : UPCA", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("123456789012", BXL_BCS_UPCA, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);	
		LineFeed(2);		
	}
  
	//UPCE Printing
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText(L"BARCODE : UPCE", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("012345678901", BXL_BCS_UPCE, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}	
	
	//JAN,EAN8 Printing	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText(L"BARCODE : JAN/EAN8", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("12345678", BXL_BCS_JAN8, 50, i, BXL_ALIGNMENT_RIGHT, BXL_BC_TEXT_ABOVE);
		LineFeed(2);		
	}
	

	//JAN,EAN8 Printing	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText(L"BARCODE : JAN/EAN13\n", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("1234567890123", BXL_BCS_EAN13, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}
	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText(L"BARCODE : CODE39\n", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("12", BXL_BCS_Code39, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}
	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText(L"BARCODE : ITF\n", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("1234", BXL_BCS_ITF, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}
	
	lResult = PrintText(L"BARCODE : PDF417\n", BXL_ALIGNMENT_LEFT, 0,0);
	if(lResult != BXL_SUCCESS)
	{
		strError.Format(L"PrintTExt is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = PrintBarcode("12345647890123456478901234564789012345647890", BXL_BCS_PDF417, 255, 2, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
	if(lResult != BXL_SUCCESS)
	{
		strError.Format(L"PrintBarcode is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}
	LineFeed(2);
}

void CPrintingDlg::OnButton5() 
{
	CString strError;
	long lResult = 0;
	lResult = CheckPrinter();
	//Printer State Check
	if( lResult != BXL_SUCCESS)
	{		
		strError.Format(L"Printer is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = GetStat();
	if( lResult != BXL_STS_NORMAL)
	{
		strError.Format(L"Printer State is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}
	
	SetCharacterSet(1); //katakana
	//SetCharacterSet(437); //USA : Default CodePage

	for(int i = 128; i < 256; i++)
	{
		CString strText;
		strText.Format(L"%c\n",i);
		PrintText(strText, BXL_ALIGNMENT_LEFT, 0, 0);
	}
	
}

void CPrintingDlg::OnOK() 
{
	// TODO: Add extra validation here	
	CDialog::OnOK();
}
