// SampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample.h"
#include "SampleDlg.h"

//#include "../inc/ExportFunc.h"
#include "../inc/DynamicFunc.h"
#include "../inc/BxlConst.h"

#include "PrintingDlg.h"
#include "MSRDlg.h"
#include "ETCDlg.h"
#include "StatusDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampleDlg dialog

CSampleDlg::CSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSampleDlg)
	m_strPort = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampleDlg)
	DDX_Text(pDX, IDC_EDIT1, m_strPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSampleDlg, CDialog)
	//{{AFX_MSG_MAP(CSampleDlg)
	ON_BN_CLICKED(IDC_BUTTON_PORTOPEN, OnButtonPortopen)
	ON_BN_CLICKED(IDC_BUTTON_PORTCLOSE, OnButtonPortclose)
	ON_BN_CLICKED(IDC_BUTTON_PRINTING, OnButtonPrinting)
	ON_BN_CLICKED(IDC_BUTTON_MSR, OnButtonMsr)
	ON_BN_CLICKED(IDC_BUTTON_MSRREAD, OnButtonMsrread)
	ON_BN_CLICKED(IDC_BUTTON_ETC, OnButtonEtc)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, OnButtonExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleDlg message handlers

BOOL CSampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	// TODO: Add extra initialization here
	
	
	m_strPort = L"COM8:19200 "; 

	GetDlgItem(IDC_BUTTON_PRINTING)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSRREAD)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_ETC)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSR)->EnableWindow(FALSE);

	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}



void CSampleDlg::OnButtonPortopen() 
{
	
	UpdateData(TRUE);
	
	long lResult;

	lResult = PrinterOpen(m_strPort,1000);	

	if(lResult != BXL_SUCCESS && lResult != BXL_WATING_OPEN)
	{
		CString strdata;
		strdata.Format(L"Error Code = %d", lResult);
		AfxMessageBox(strdata);		
		return ;
	}
	
 
	GetDlgItem(IDC_BUTTON_PRINTING)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_MSRREAD)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_ETC)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_MSR)->EnableWindow(TRUE);
	
}

void CSampleDlg::OnButtonPortclose() 
{

	PrinterClose();

	GetDlgItem(IDC_BUTTON_PRINTING)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSRREAD)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_ETC)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSR)->EnableWindow(FALSE);
	
}

void CSampleDlg::OnButtonPrinting() 
{
	CPrintingDlg dlg;
	dlg.DoModal();
}

void CSampleDlg::OnButtonMsr() 
{
	CMSRDlg dlg;
	dlg.DoModal();
	// TODO: Add your control notification handler code here
	
}

void CSampleDlg::OnButtonMsrread() 
{
	CStatusDlg dlg;
	dlg.DoModal();
	
}

void CSampleDlg::OnButtonEtc() 
{
	CETCDlg dlg;
	dlg.DoModal();
	
}

void CSampleDlg::OnButtonExit() 
{
	
	CDialog::OnOK();	
}
