// StatusDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample.h"
#include "StatusDlg.h"

//#include "../inc/ExportFunc.h"
#include "../inc/DynamicFunc.h"
#include "../inc/BxlConst.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStatusDlg dialog


CStatusDlg::CStatusDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStatusDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStatusDlg)
	m_bState1 = FALSE;
	m_bState2 = FALSE;
	m_bState3 = FALSE;
	m_bState4 = FALSE;
	m_bState5 = FALSE;
	m_bState6 = FALSE;
	m_strPower = _T("");
	//}}AFX_DATA_INIT
}


void CStatusDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStatusDlg)
	DDX_Check(pDX, IDC_CHECK1, m_bState1);
	DDX_Check(pDX, IDC_CHECK2, m_bState2);
	DDX_Check(pDX, IDC_CHECK3, m_bState3);
	DDX_Check(pDX, IDC_CHECK4, m_bState4);
	DDX_Check(pDX, IDC_CHECK5, m_bState5);
	DDX_Check(pDX, IDC_CHECK6, m_bState6);
	DDX_Text(pDX, IDC_TEXT_POWERLEVEL, m_strPower);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStatusDlg, CDialog)
	//{{AFX_MSG_MAP(CStatusDlg)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStatusDlg message handlers

BOOL CStatusDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	GetDlgItem(IDC_CHECK1)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK2)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK3)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK4)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK5)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK6)->EnableWindow(FALSE);
	
	SetTimer(1, 1000, NULL);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CStatusDlg::OnTimer(UINT nIDEvent) 
{
	long lResult = CheckPrinter();
	if(lResult == BXL_NOT_OPENED)
		return;
	int lState = (int)GetStat();
	m_bState1 = FALSE;
	m_bState2 = FALSE;
	m_bState3 = FALSE;
	m_bState4 = FALSE;
	m_bState5 = FALSE;
	m_bState6 = FALSE;

	if( (lState & BXL_STS_PAPEREMPTY)	== BXL_STS_PAPEREMPTY)
	{
		m_bState2 = TRUE;
	}

	if( (lState & BXL_STS_COVEROPEN)	== BXL_STS_COVEROPEN)
	{
		m_bState1 = TRUE;
	}

	if( (lState & BXL_STS_MSR_READY)	== BXL_STS_MSR_READY)
	{
		m_bState3 = TRUE;
	}	

	if( (lState & BXL_STS_ERROR)	== BXL_STS_ERROR)
	{
		m_bState4 = TRUE;
	}

	if( (lState & BXL_STS_NOT_OPEN)	== BXL_STS_NOT_OPEN)
	{
		m_bState5 = TRUE;
	}

	if( lState== BXL_STS_NORMAL)
	{
		m_bState6 = TRUE;
	}

	long lPower = GetPowerValue();

	switch(lPower)
	{
	case BXL_PWR_HIGH:
		m_strPower = L"HIGH";
		break;
	case BXL_PWR_MIDDLE:
		m_strPower = L"MIDDLE";
		break;
	case BXL_PWR_LOW:
		m_strPower = L"LOW";
		break;
	case BXL_PWR_SMALL:
		m_strPower = L"SMALL";
		break;
	case BXL_PWR_NOT:	
		m_strPower = L"Not";
		break;
	default :
		m_strPower = L"UNknown";
		break;
		
	}
	UpdateData(FALSE);
	
	CDialog::OnTimer(nIDEvent);
}

void CStatusDlg::OnOK() 
{
	KillTimer(1);
	
	CDialog::OnOK();
}
